<?php
require_once 'config.php';
$conn = connectDB();
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
  case 'GET':
    // Get all classes or a specific class by ID
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if ($id) {
      $stmt = $conn->prepare("SELECT * FROM classes WHERE id=?");
      $stmt->bind_param("i", $id);
      $stmt->execute();
      $result = $stmt->get_result();
      $class = $result->fetch_assoc();
      
      if (!$class) {
        returnError("Class not found", 404);
      }
      
      returnResponse($class);
    } else {
      // Get all classes with optional search and status filter
      $search = isset($_GET['search']) ? $_GET['search'] : '';
      $status = isset($_GET['status']) ? $_GET['status'] : '';
      
      $sql = "SELECT * FROM classes";
      $params = [];
      $types = "";
      
      if ($search || $status) {
        $sql .= " WHERE";
        if ($search) {
          $sql .= " name LIKE ?";
          $searchTerm = "%$search%";
          $params[] = $searchTerm;
          $types .= "s";
        }
        
        if ($search && $status) {
          $sql .= " AND";
        }
        
        if ($status) {
          $sql .= " status=?";
          $params[] = $status;
          $types .= "s";
        }
      }
      
      $sql .= " ORDER BY start_date DESC";
      $stmt = $conn->prepare($sql);
      
      if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
      }
      
      $stmt->execute();
      $result = $stmt->get_result();
      $classes = $result->fetch_all(MYSQLI_ASSOC);
      
      returnResponse($classes);
    }
    break;

  case 'POST':
    // Add a new class
    $data = getRequestBody();

    // Validate required fields
    $requiredFields = ['name', 'type', 'teacher', 'schedule', 'time_slot', 'sessions', 'fee', 'start_date', 'status'];
    foreach ($requiredFields as $field) {
      if (!isset($data[$field])) {
        returnError("Field '$field' is required", 400);
      }
    }

  /* lệnh gốc
    $stmt = $conn->prepare("INSERT INTO classes (name, type, teacher, schedule, time_slot, sessions, fee, start_date, status, note) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $startDate = (string)date('Y-m-d', strtotime($data['start_date']));
    $stmt->bind_param("sssssifsss", 
      $data['name'], 
      $data['type'], 
      $data['teacher'], 
      $data['schedule'], 
      $data['time_slot'], 
      $data['sessions'], 
      $data['fee'], 
      $startDate, 
      $data['status'], 
      $data['note'] ?? ''
    );
    */
    // Lệnh Update
    
    // Chuẩn bị câu lệnh INSERT cho bảng classes
$stmt = $conn->prepare("INSERT INTO classes (name, type, teacher, schedule, time_slot, sessions, fee, start_date, status, note) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

// Kiểm tra nếu prepare thất bại thì dừng và thông báo lỗi
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

// Xử lý dữ liệu đầu vào và ép kiểu phù hợp
$name = $data['name'] ?? '';
$type = $data['type'] ?? '';
$teacher = $data['teacher'] ?? '';
$schedule = $data['schedule'] ?? '';
$time_slot = $data['time_slot'] ?? '';
$sessions = isset($data['sessions']) ? (int)$data['sessions'] : 0;
$fee = isset($data['fee']) ? (float)$data['fee'] : 0.0;

// Kiểm tra và định dạng ngày bắt đầu
if (isset($data['start_date']) && strtotime($data['start_date'])) {
    $startDate = date('Y-m-d', strtotime($data['start_date']));
} else {
    $startDate = date('Y-m-d'); // Ngày hiện tại nếu không hợp lệ
}

$status = $data['status'] ?? '';
$note = $data['note'] ?? '';

// Bind tham số với kiểu dữ liệu chính xác:
// s - string; i - integer; d - double
$stmt->bind_param(
    "sssssidsss",
    $name,
    $type,
    $teacher,
    $schedule,
    $time_slot,
    $sessions,
    $fee,
    $startDate,
    $status,
    $note
);


    
    if (!$stmt->execute()) {
      returnError("Failed to add class: " . $conn->error);
    }
    
    $id = $conn->insert_id;

    // Return the newly created class
    $stmt = $conn->prepare("SELECT * FROM classes WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $class = $result->fetch_assoc();
    
    returnResponse($class, 201);
    break;

  case 'PUT':
    // Update an existing class
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if (!$id) {
      returnError("Class ID is required", 400);
    }
    
    $data = getRequestBody();

    // Check if class exists
    $stmt = $conn->prepare("SELECT id FROM classes WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
      returnError("Class not found", 404);
    }

    // Update class
$startDate = date('Y-m-d', strtotime($data['start_date']));
$note = isset($data['note']) ? $data['note'] : '';

// Chuẩn bị truy vấn
$stmt = $conn->prepare("
    UPDATE classes 
    SET name = ?, type = ?, teacher = ?, schedule = ?, time_slot = ?, sessions = ?, fee = ?, start_date = ?, status = ?, note = ? 
    WHERE id = ?
");

if (!$stmt) {
    throw new Exception("Lỗi prepare statement: " . $conn->error);
}

// Xác định kiểu dữ liệu
// Giả sử: sessions & status & id là int, fee là float (double)
// Chuỗi: name, type, teacher, schedule, time_slot, start_date, note
$stmt->bind_param(
    "sssssidsssi",
    $data['name'],
    $data['type'],
    $data['teacher'],
    $data['schedule'],
    $data['time_slot'],
    $data['sessions'],
    $data['fee'],
    $startDate,
    $data['status'],
    $note,
    $id
);


    if (!$stmt->execute()) {
      returnError("Failed to update class: " . $conn->error);
    }

    // Return the updated class
    $stmt = $conn->prepare("SELECT * FROM classes WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $class = $result->fetch_assoc();
    
    returnResponse($class);
    break;

  case 'DELETE':
    // Delete a class
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if (!$id) {
      returnError("Class ID is required", 400);
    }

    // Check if class exists
    $stmt = $conn->prepare("SELECT id FROM classes WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
      returnError("Class not found", 404);
    }

    // Delete class
    $stmt = $conn->prepare("DELETE FROM classes WHERE id=?");
    $stmt->bind_param("i", $id);
    
    if (!$stmt->execute()) {
      returnError("Failed to delete class: " . $conn->error);
    }
    
    returnResponse(['message' => 'Class deleted successfully']);
    break;

  default:
    returnError('Method not allowed', 405);
}

$conn->close();
?>