<?php
// Database Configuration
define('DB_HOST', 'quanly.toeiccosaothaybao.com');
define('DB_PORT', '3306');
define('DB_NAME', 'toeiccos_english_center_db');
define('DB_USER', 'toeiccos_english_center_db');
define('DB_PASS', 'Saobang92#');

// Set headers for CORS and JSON responses
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(200);
  exit();
}

// Connect to database
function connectDB() {
  $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
  
  // Check connection
  if ($conn->connect_error) {
    returnError('Database connection failed: ' . $conn->connect_error);
  }
  
  // Set UTF-8 charset
  $conn->set_charset("utf8mb4");
  
  return $conn;
}

// Return error response
function returnError($message, $code = 500) {
  http_response_code($code);
  echo json_encode(['error' => $message]);
  exit();
}

// Return success response
function returnResponse($data, $code = 200) {
  http_response_code($code);
  echo json_encode($data);
  exit();
}

// Get JSON request body
function getRequestBody() {
  $json = file_get_contents('php://input');
  return json_decode($json, true);
}

// Function to ensure dates are always returned as strings
function ensureDateString($date) {
  if ($date === null) {
    return null;
  }
  
  if ($date instanceof DateTime) {
    return $date->format('Y-m-d H:i:s');
  }
  
  return (string)$date;
}
?>