<?php
require_once 'config.php';
$conn = connectDB();
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        // Get enrollments with optional filters
        $studentId = isset($_GET['student_id']) ? (int)$_GET['student_id'] : null;
        $classId = isset($_GET['class_id']) ? (int)$_GET['class_id'] : null;
        $active = isset($_GET['active']) ? (int)$_GET['active'] : null;
        
        $sql = "SELECT * FROM enrollments WHERE 1=1";
        $params = [];
        $types = "";
        
        if ($studentId) {
            $sql .= " AND student_id=?";
            $params[] = $studentId;
            $types .= "i";
        }
        
        if ($classId) {
            $sql .= " AND class_id=?";
            $params[] = $classId;
            $types .= "i";
        }
        
        if ($active !== null) {
            $sql .= " AND is_active=?";
            $params[] = $active;
            $types .= "i";
        }
        
        $sql .= " ORDER BY enroll_date DESC";
        
        $stmt = $conn->prepare($sql);
        if (!empty($params)) {
            $stmt->bind_param($types, ...$params);
        }
        
        $stmt->execute();
        $result = $stmt->get_result();
        $enrollments = $result->fetch_all(MYSQLI_ASSOC);
        
        returnResponse($enrollments);
        break;
        
    case 'POST':
        // Add a new enrollment
        $data = getRequestBody();
        
        // Validate required fields
        if (!isset($data['student_id']) || !isset($data['class_id']) || !isset($data['fee'])) {
            returnError("student_id, class_id, and fee are required", 400);
        }
        
        // Check if student and class exist
        $stmt = $conn->prepare("SELECT id FROM students WHERE id=?");
        $stmt->bind_param("i", $data['student_id']);
        $stmt->execute();
        if ($stmt->get_result()->num_rows === 0) {
            returnError("Student not found", 404);
        }
        
        $stmt = $conn->prepare("SELECT id FROM classes WHERE id=?");
        $stmt->bind_param("i", $data['class_id']);
        $stmt->execute();
        if ($stmt->get_result()->num_rows === 0) {
            returnError("Class not found", 404);
        }
        
        // Check if enrollment already exists
        $stmt = $conn->prepare("SELECT id FROM enrollments WHERE student_id=? AND class_id=? AND is_active=1");
        $stmt->bind_param("ii", $data['student_id'], $data['class_id']);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            returnError("Student is already enrolled in this class", 400);
        }
        
        // Create enrollment
        // Tạo bản ghi enrollments
        $stmt = $conn->prepare("INSERT INTO enrollments (student_id, class_id, fee, note, online, transfer, is_active, status) VALUES (?, ?, ?, ?, ?, ?, 1, ?)");
        
        // Kiểm tra chuẩn bị câu lệnh
        if (!$stmt) {
            die("Prepare failed: " . $conn->error);
        }
        
        // Xử lý dữ liệu đầu vào và ép kiểu
        $student_id = isset($data['student_id']) ? (int)$data['student_id'] : 0;
        $class_id = isset($data['class_id']) ? (int)$data['class_id'] : 0;
        $fee = isset($data['fee']) ? (float)$data['fee'] : 0.0;
        $note = $data['note'] ?? '';
        $online = isset($data['online']) ? ($data['online'] ? 1 : 0) : 0;
        $transfer = isset($data['transfer']) ? ($data['transfer'] ? 1 : 0) : 0;
        $status = $data['status'] ?? ($fee > 0 ? 'đang học' : 'chưa học');
        
        // Bind tham số với kiểu:
        // i - integer
        // d - double
        // s - string
        $stmt->bind_param(
            "iidsiis",
            $student_id,
            $class_id,
            $fee,
            $note,
            $online,
            $transfer,
            $status
        );
        
        if (!$stmt->execute()) {
            returnError("Failed to create enrollment: " . $conn->error);
        }
        
        $id = $conn->insert_id;
        
        
        // Return the new enrollment
        $stmt = $conn->prepare("SELECT * FROM enrollments WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $enrollment = $result->fetch_assoc();
        
        returnResponse($enrollment, 201);
        break;
        
    case 'PUT':
        // Update an enrollment (e.g., to deactivate)
        $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
        if (!$id) {
            returnError("Enrollment ID is required", 400);
        }
        
        $data = getRequestBody();
        
        // Check if enrollment exists
        $stmt = $conn->prepare("SELECT id FROM enrollments WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 0) {
            returnError("Enrollment not found", 404);
        }
        
        // Update enrollment
        $sql = "UPDATE enrollments SET";
        $params = [];
        $types = "";
        $updates = [];
        
        if (isset($data['fee'])) {
            $updates[] = " fee=?";
            $params[] = $data['fee'];
            $types .= "d";
        }
        
        if (isset($data['note'])) {
            $updates[] = " note=?";
            $params[] = $data['note'];
            $types .= "s";
        }
        
        if (isset($data['online'])) {
            $updates[] = " online=?";
            $params[] = $data['online'] ? 1 : 0;
            $types .= "i";
        }
        
        if (isset($data['transfer'])) {
            $updates[] = " transfer=?";
            $params[] = $data['transfer'] ? 1 : 0;
            $types .= "i";
        }
        
        if (isset($data['is_active'])) {
            $updates[] = " is_active=?";
            $params[] = $data['is_active'] ? 1 : 0;
            $types .= "i";
        }
        
        if (isset($data['status'])) {
            $updates[] = " status=?";
            $params[] = $data['status'];
            $types .= "s";
        }
        
        if (empty($updates)) {
            returnError("No fields to update", 400);
        }
        
        $sql .= implode(",", $updates);
        $sql .= " WHERE id=?";
        $params[] = $id;
        $types .= "i";
        
        $stmt = $conn->prepare($sql);
        $stmt->bind_param($types, ...$params);
        
        if (!$stmt->execute()) {
            returnError("Failed to update enrollment: " . $conn->error);
        }
        
        // Return the updated enrollment
        $stmt = $conn->prepare("SELECT * FROM enrollments WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $enrollment = $result->fetch_assoc();
        
        returnResponse($enrollment);
        break;
        
    case 'DELETE':
        // Delete an enrollment
        $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
        if (!$id) {
            returnError("Enrollment ID is required", 400);
        }
        
        // Check if enrollment exists
        $stmt = $conn->prepare("SELECT id FROM enrollments WHERE id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 0) {
            returnError("Enrollment not found", 404);
        }
        
        // Delete enrollment
        $stmt = $conn->prepare("DELETE FROM enrollments WHERE id=?");
        $stmt->bind_param("i", $id);
        
        if (!$stmt->execute()) {
            returnError("Failed to delete enrollment: " . $conn->error);
        }
        
        returnResponse(['message' => 'Enrollment deleted successfully']);
        break;
        
    default:
        returnError('Method not allowed', 405);
}

$conn->close();
?>