<?php
require_once 'config.php';
$conn = connectDB();
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
  case 'GET':
    // Get reservations with optional filters
    $studentId = isset($_GET['student_id']) ? (int)$_GET['student_id'] : null;
    $classId = isset($_GET['class_id']) ? (int)$_GET['class_id'] : null;

    $sql = "SELECT * FROM reservations WHERE 1=1";
    $params = [];
    $types = "";

    if ($studentId) {
      $sql .= " AND student_id=?";
      $params[] = $studentId;
      $types .= "i";
    }

    if ($classId) {
      $sql .= " AND class_id=?";
      $params[] = $classId;
      $types .= "i";
    }

    $sql .= " ORDER BY reserve_date DESC";
    $stmt = $conn->prepare($sql);
    
    if (!empty($params)) {
      $stmt->bind_param($types, ...$params);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    $reservations = $result->fetch_all(MYSQLI_ASSOC);
    
    returnResponse($reservations);
    break;

  case 'POST':
    // Add a new reservation
    $data = getRequestBody();

    // Validate required fields
    if (!isset($data['student_id']) || !isset($data['class_id']) || !isset($data['reserve_fee']) || !isset($data['sessions_attended'])) {
      returnError("student_id, class_id, reserve_fee, and sessions_attended are required", 400);
    }

    // Check if student and class exist
    $stmt = $conn->prepare("SELECT id FROM students WHERE id=?");
    $stmt->bind_param("i", $data['student_id']);
    $stmt->execute();
    
    if ($stmt->get_result()->num_rows === 0) {
      returnError("Student not found", 404);
    }

    $stmt = $conn->prepare("SELECT id FROM classes WHERE id=?");
    $stmt->bind_param("i", $data['class_id']);
    $stmt->execute();
    
    if ($stmt->get_result()->num_rows === 0) {
      returnError("Class not found", 404);
    }

    // Create reservation
// Chuẩn hóa dữ liệu
$studentId         = (int)$data['student_id'];
$classId           = (int)$data['class_id'];
$reserveFee        = (float)$data['reserve_fee'];
$sessionsAttended  = (int)$data['sessions_attended'];
$note              = isset($data['note']) ? (string)$data['note'] : '';

// Chuẩn bị truy vấn
$stmt = $conn->prepare("INSERT INTO reservations (student_id, class_id, reserve_fee, sessions_attended, note) VALUES (?, ?, ?, ?, ?)");
if (!$stmt) {
    throw new Exception("Lỗi prepare statement: " . $conn->error);
}

// Bind và thực thi
$stmt->bind_param(
    "iidis",
    $studentId,
    $classId,
    $reserveFee,
    $sessionsAttended,
    $note
);
    
    if (!$stmt->execute()) {
      returnError("Failed to create reservation: " . $conn->error);
    }
    
    $id = $conn->insert_id;

    // Return the new reservation
    $stmt = $conn->prepare("SELECT * FROM reservations WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $reservation = $result->fetch_assoc();
    
    returnResponse($reservation, 201);
    break;

  case 'PUT':
    // Update a reservation
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if (!$id) {
      returnError("Reservation ID is required", 400);
    }
    
    $data = getRequestBody();

    // Check if reservation exists
    $stmt = $conn->prepare("SELECT id FROM reservations WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
      returnError("Reservation not found", 404);
    }

    // Build update query
    $sql = "UPDATE reservations SET";
    $params = [];
    $types = "";
    $updates = [];

    if (isset($data['reserve_fee'])) {
      $updates[] = " reserve_fee=?";
      $params[] = $data['reserve_fee'];
      $types .= "d";
    }

    if (isset($data['sessions_attended'])) {
      $updates[] = " sessions_attended=?";
      $params[] = $data['sessions_attended'];
      $types .= "i";
    }

    if (isset($data['note'])) {
      $updates[] = " note=?";
      $params[] = $data['note'];
      $types .= "s";
    }

    if (empty($updates)) {
      returnError("No fields to update", 400);
    }

    $sql .= implode(",", $updates);
    $sql .= " WHERE id=?";
    $params[] = $id;
    $types .= "i";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$params);
    
    if (!$stmt->execute()) {
      returnError("Failed to update reservation: " . $conn->error);
    }

    // Return the updated reservation
    $stmt = $conn->prepare("SELECT * FROM reservations WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $reservation = $result->fetch_assoc();
    
    returnResponse($reservation);
    break;

  case 'DELETE':
    // Delete a reservation
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if (!$id) {
      returnError("Reservation ID is required", 400);
    }

    // Check if reservation exists
    $stmt = $conn->prepare("SELECT id FROM reservations WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
      returnError("Reservation not found", 404);
    }

    // Delete reservation
    $stmt = $conn->prepare("DELETE FROM reservations WHERE id=?");
    $stmt->bind_param("i", $id);
    
    if (!$stmt->execute()) {
      returnError("Failed to delete reservation: " . $conn->error);
    }
    
    returnResponse(['message' => 'Reservation deleted successfully']);
    break;

  default:
    returnError('Method not allowed', 405);
}

$conn->close();
?>