<?php
require_once 'config.php';
$conn = connectDB();
$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
  case 'GET':
    // Get tasks with optional filter for completed status
    $completed = isset($_GET['completed']) ? (int)$_GET['completed'] : null;
    
    $sql = "SELECT * FROM tasks";
    $params = [];
    $types = "";
    
    if ($completed !== null) {
      $sql .= " WHERE completed=?";
      $params[] = $completed;
      $types .= "i";
    }
    
    $sql .= " ORDER BY date DESC";
    $stmt = $conn->prepare($sql);
    
    if (!empty($params)) {
      $stmt->bind_param($types, ...$params);
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    $tasks = $result->fetch_all(MYSQLI_ASSOC);
    
    returnResponse($tasks);
    break;

  case 'POST':
    // Add a new task
    $data = getRequestBody();

    // Validate required fields
    if (!isset($data['name']) || !isset($data['content']) || !isset($data['date'])) {
      returnError("Name, content, and date are required", 400);
    }

    // Create task
   /*
    $stmt = $conn->prepare("INSERT INTO tasks (name, content, date, note, completed, priority) VALUES (?, ?, ?, ?, ?, ?)");
    $date = (string)date('Y-m-d', strtotime($data['date']));
    $completed = isset($data['completed']) ? ($data['completed'] ? 1 : 0) : 0;
    $priority = isset($data['priority']) ? $data['priority'] : 'Trung bình';

    $stmt->bind_param("ssssss", 
      $data['name'], 
      $data['content'], 
      $date, 
      $data['note'] ?? '', 
      "$completed", 
      $priority
    );
    */
    
    // code thay thế:
    $stmt = $conn->prepare("INSERT INTO tasks (name, content, date, note, completed, priority) VALUES (?, ?, ?, ?, ?, ?)");

if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

$date = isset($data['date']) && strtotime($data['date']) ? date('Y-m-d', strtotime($data['date'])) : date('Y-m-d');
$completed = isset($data['completed']) ? ($data['completed'] ? 1 : 0) : 0;
$priority = isset($data['priority']) ? $data['priority'] : 'Trung bình';
$note = $data['note'] ?? '';

$stmt->bind_param(
    "ssssis",
    $data['name'],
    $data['content'],
    $date,
    $note,
    $completed,
    $priority
);

    if (!$stmt->execute()) {
      returnError("Failed to add task: " . $conn->error);
    }
    
    $id = $conn->insert_id;

    // Return the new task
    $stmt = $conn->prepare("SELECT * FROM tasks WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $task = $result->fetch_assoc();
    
    returnResponse($task, 201);
    break;

  case 'PUT':
    // Update a task
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if (!$id) {
      returnError("Task ID is required", 400);
    }
    
    $data = getRequestBody();

    // Check if task exists
    $stmt = $conn->prepare("SELECT id FROM tasks WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
      returnError("Task not found", 404);
    }

    // Build update query
    $sql = "UPDATE tasks SET";
    $params = [];
    $types = "";
    $updates = [];

    if (isset($data['name'])) {
      $updates[] = " name=?";
      $params[] = $data['name'];
      $types .= "s";
    }

    if (isset($data['content'])) {
      $updates[] = " content=?";
      $params[] = $data['content'];
      $types .= "s";
    }

    if (isset($data['date'])) {
      $updates[] = " date=?";
      $params[] = (string)date('Y-m-d', strtotime($data['date']));
      $types .= "s";
    }

    if (isset($data['note'])) {
      $updates[] = " note=?";
      $params[] = $data['note'];
      $types .= "s";
    }

    if (isset($data['completed'])) {
      $updates[] = " completed=?";
      $params[] = $data['completed'] ? 1 : 0;
      $types .= "i";
    }

    if (isset($data['priority'])) {
      $updates[] = " priority=?";
      $params[] = $data['priority'];
      $types .= "s";
    }

    if (empty($updates)) {
      returnError("No fields to update", 400);
    }

    $sql .= implode(",", $updates);
    $sql .= " WHERE id=?";
    $params[] = $id;
    $types .= "i";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param($types, ...$params);
    
    if (!$stmt->execute()) {
      returnError("Failed to update task: " . $conn->error);
    }

    // Return the updated task
    $stmt = $conn->prepare("SELECT * FROM tasks WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $task = $result->fetch_assoc();
    
    returnResponse($task);
    break;

  case 'DELETE':
    // Delete a task
    $id = isset($_GET['id']) ? (int)$_GET['id'] : null;
    
    if (!$id) {
      returnError("Task ID is required", 400);
    }

    // Check if task exists
    $stmt = $conn->prepare("SELECT id FROM tasks WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows === 0) {
      returnError("Task not found", 404);
    }

    // Delete task
    $stmt = $conn->prepare("DELETE FROM tasks WHERE id=?");
    $stmt->bind_param("i", $id);
    
    if (!$stmt->execute()) {
      returnError("Failed to delete task: " . $conn->error);
    }
    
    returnResponse(['message' => 'Task deleted successfully']);
    break;

  default:
    returnError('Method not allowed', 405);
}

$conn->close();
?>